/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package zold.data.base.connectors;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;


/**
 *
 * @author claitang1
 * ne sert à priori plus à rien
 * récupérait toutes les ressources en local, mais c'était trop lent
 */
public class _SemanticStorage {
    private String remoteService, foaf, rdfs;
    public _SemanticStorage(){
        remoteService = "http://dbpedia.org/sparql";
        //prefix pour signifier 'de type'
        rdfs = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>";
        foaf = "PREFIX foaf:  <http://xmlns.com/foaf/0.1/>";
    }
    //resupération des éléments DBPedia depuis URL
    public ArrayList getDesc(String url){
        ArrayList result = new ArrayList();
        result.add(getLabel(url));
        result.add(getAbstract(url));
        return result;
    }
    //recupération du label qui est l'equivalent d'un titre
    private String getLabel(String url){
        String result = "NULL";
        try {
                        String myQuery = foaf+" "+ rdfs+
                                " SELECT DISTINCT ?label " +
                                "WHERE {" +
                                "<"+url+"> rdfs:label ?label." +
                                " FILTER (lang(?label) = 'fr')}";
            Query yourSparqlQuery = QueryFactory.create(myQuery);
            // configuration to access the online endpoint
            QueryExecution qehttp = QueryExecutionFactory.sparqlService(remoteService, yourSparqlQuery);
            ResultSet rs = qehttp.execSelect();
            if(rs.hasNext()){
                QuerySolution soln = (QuerySolution) rs.next();
                result = (soln.get("label").toString());
            }
            qehttp.close();
        }
        catch(Exception e) {
            System.out.println("Echec de la requete label sur: "+url);
        }
        return result;
    }
    //recupération des comments qui sont l'equivalent d'un résumé.
    private String getAbstract(String url){
            String result = "NULL";
        try {
            String myQuery = foaf+" "+ rdfs+
                                " SELECT DISTINCT ?abstract " +
                                "WHERE {" +
                                "<"+url+"> rdfs:comment ?abstract." +
                                " FILTER (lang(?abstract) = 'fr')}";
            Query yourSparqlQuery = QueryFactory.create(myQuery);
            // configuration to access the online endpoint
            QueryExecution qehttp = QueryExecutionFactory.sparqlService(remoteService, yourSparqlQuery);
            ResultSet rs = qehttp.execSelect();
            if(rs.hasNext()){
                QuerySolution soln = (QuerySolution) rs.next();
                result = (soln.get("abstract").toString());
            }
            qehttp.close();
        }
        catch(Exception e) {
            System.out.println("Echec de la requete comment sur: "+url);
        }
        return result;
    }
}
